using System;
using System.Net;
using System.Net.NetworkInformation;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Agile1
{
   public partial class Form1 : Form
   {
      public Form1()
      {
         InitializeComponent();
         System.Net.NetworkInformation.NetworkChange.NetworkAddressChanged +=
            new NetworkAddressChangedEventHandler(NetworkChange_NetworkAddressChanged);
         System.Net.NetworkInformation.NetworkChange.NetworkAvailabilityChanged +=
            new NetworkAvailabilityChangedEventHandler(
            NetworkChange_NetworkAvailabilityChanged);
      }

      delegate void RespondDelegate();

      void NetworkChange_NetworkAvailabilityChanged(object sender,
         System.Net.NetworkInformation.NetworkAvailabilityEventArgs e)
      {
         RespondDelegate d = delegate()
         {
            lbLog.Items.Add(
               string.Format("Nastpia zmiana dostpnoci sieci. Sie {0} dostpna.",
               e.IsAvailable ? "jest" : "nie jest"));
         };
         this.Invoke(d);
      }

      void NetworkChange_NetworkAddressChanged(object sender, EventArgs e)
      {
         RespondDelegate d = delegate()
         {
            bool hasOneGateway = false;
            NetworkInterface[] nis = NetworkInterface.GetAllNetworkInterfaces();
            foreach (NetworkInterface ni in nis)
            {
               IPInterfaceProperties ipProps = ni.GetIPProperties();
               if (ipProps.GatewayAddresses.Count > 0)
                  hasOneGateway = true;
            }
            if (hasOneGateway)
               lbLog.Items.Add("Adres sieciowy uleg zmianie (prawdopodobnie wci w trybie online)");
            else
               lbLog.Items.Add("Adres sieciowy uleg zmianie (prawdopodobnie praca w trybie offline)");
         };
         this.Invoke(d);
      }
   }
}
